	function [FA, HA, area, power] = GET_ADDTREE_COST(coeffs);
 
	% Computes the required number of full and half adders in an adder
	% tree where the coefficients are in CSD representation.
	% The area and power estimations are normalized so that the cost for one
	% full adder is 1.
	
	% Compute max- and min-outputs from the coefficients
	% (note that a better estimation can be obtained if the matrix of 
	%  and-products is known)
	
	% Author: 			Kenny Johansson, 2005-03-03
	% Modified by: 		
	% Copyright:		by authors - not released for commercial use
	% Version: 			1 
	% Known bugs:		
	% Report bugs to:	Wanhammar@gmail.com
	%
	
	max_out = sum(coeffs(find(coeffs > 0)));
	min_out = sum(coeffs(find(coeffs < 0)));
	
	% Compute the required number of output bits (number of significance levels)
	if max_out < 0
		numsign = ceil(log2(abs(min_out))) + 1;
	elseif min_out >= 0
		numsign = ceil(log2(max_out + 1)) + 1;
	else
		numsign = max(ceil(log2(max_out + 1)), ceil(log2(abs(min_out)))) + 1;
	end

	% Convert the coefficients to Canonic Signed Digit representation
	numprod = length(coeffs);
	[coeffs, w] = int2csd_vec(coeffs);
	if w < numsign
		coeffs = [zeros(numprod, numsign - w), coeffs];
		w = numsign;
	end

	% Compute compensation
	compensation = -sum(2.^(w - 1:-1:0)*(coeffs == -1)');
	
	% Convert the integer compensation value to two's complement representation
	% Then flip and truncate the vector
	[compensation_vector, w_comp] = int2twoc_vec(compensation);
	if w_comp < numsign
		% Sign extend (the compensation is always negative)
		compensation_vector = [ones(1, numsign - w_comp), compensation_vector];
	end
	compensation_vector = fliplr(compensation_vector);
	compensation_vector = compensation_vector(1:numsign);
	
	% Compute the vector lengths
	coeffs = fliplr(coeffs(:, w - numsign + 1:w));
	vectorlengths = sum(abs(coeffs)) + compensation_vector - 1;
	k = 0; % k is the number of tree levels
	invector = vectorlengths + 1; % Number-of-ones vector
	while max(invector) > 2
		k = k + 1;
		invector = ppreduceha(invector);
		tmpvec = invector;
		tmpvec(max(find(tmpvec)) + 1:length(tmpvec)) = inf;
		% Each row in 'vectorlengths' corresponds to one tree level
		vectorlengths = [vectorlengths, inf*ones(k, 1); tmpvec - 1];
	end
	vectorlengths = vectorlengths(:, 1:numsign);
	
	% Compute the total number of FA and HA
	FA = 0;
	HA = 0;
	for i = 1:k
		inwd = vectorlengths(i, :);
		inwd(find(isinf(inwd))) = []; % Remove inf
		FA = FA + sum(floor((inwd + 1)/3));
		HA = HA + sum(mod(inwd + 1, 3) == 2);
	end

	% Normalized area cost
	area = FA + HA*146/273;
	
	% Normalized power cost
	power = FA + HA*0.91/1.13;
